/*
 * Decompiled with CFR 0.152.
 */
package com.zhentao.controller;

import com.zhentao.common.PageResult;
import com.zhentao.common.Result;
import com.zhentao.dto.CommentCreateDTO;
import com.zhentao.dto.DynamicQueryDTO;
import com.zhentao.dto.PublishDynamicDTO;
import com.zhentao.dto.ReportCreateDTO;
import com.zhentao.entity.DynamicComments;
import com.zhentao.service.CommentService;
import com.zhentao.service.InteractionService;
import com.zhentao.service.MediaUploadService;
import com.zhentao.service.PublishService;
import com.zhentao.service.ReportService;
import com.zhentao.service.UserDynamicsService;
import com.zhentao.vo.DynamicVO;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/dynamic"})
@Validated
public class DynamicController {
    @Autowired
    private UserDynamicsService userDynamicsService;
    @Autowired
    private InteractionService interactionService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private PublishService publishService;
    @Autowired
    private MediaUploadService mediaUploadService;
    @Autowired
    private ReportService reportService;

    @GetMapping(value={"/list"})
    public Result<PageResult<DynamicVO>> getDynamicList(@Valid DynamicQueryDTO queryDTO) {
        try {
            PageResult<DynamicVO> result = this.userDynamicsService.getDynamicList(queryDTO);
            return Result.success(result);
        }
        catch (Exception e) {
            return Result.error("\u67e5\u8be2\u52a8\u6001\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @GetMapping(value={"/detail/{dynamicId}"})
    public Result<DynamicVO> getDynamicDetail(@PathVariable Integer dynamicId, @RequestParam(required=false) Integer userId) {
        try {
            DynamicVO dynamic = this.userDynamicsService.getDynamicDetail(dynamicId, userId);
            if (dynamic == null) {
                return Result.error(404, "\u52a8\u6001\u4e0d\u5b58\u5728");
            }
            return Result.success(dynamic);
        }
        catch (Exception e) {
            return Result.error("\u67e5\u8be2\u52a8\u6001\u8be6\u60c5\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @GetMapping(value={"/user/{userId}"})
    public Result<PageResult<DynamicVO>> getUserDynamics(@PathVariable Integer userId, @RequestParam(defaultValue="1") Integer pageNum, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(required=false) Integer currentUserId) {
        try {
            DynamicQueryDTO queryDTO = new DynamicQueryDTO();
            queryDTO.setTargetUserId(userId);
            queryDTO.setPageNum(pageNum);
            queryDTO.setPageSize(pageSize);
            queryDTO.setCurrentUserId(currentUserId);
            PageResult<DynamicVO> result = this.userDynamicsService.getUserDynamics(queryDTO);
            return Result.success(result);
        }
        catch (Exception e) {
            return Result.error("\u67e5\u8be2\u7528\u6237\u52a8\u6001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @GetMapping(value={"/recommend"})
    public Result<PageResult<DynamicVO>> getRecommendDynamics(@RequestParam(defaultValue="1") Integer pageNum, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(required=false) Integer userId) {
        try {
            DynamicQueryDTO queryDTO = new DynamicQueryDTO();
            queryDTO.setPageNum(pageNum);
            queryDTO.setPageSize(pageSize);
            queryDTO.setCurrentUserId(userId);
            queryDTO.setAuditStatus(1);
            queryDTO.setVisibility(1);
            PageResult<DynamicVO> result = this.userDynamicsService.getDynamicList(queryDTO);
            return Result.success(result);
        }
        catch (Exception e) {
            return Result.error("\u67e5\u8be2\u63a8\u8350\u52a8\u6001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/like"})
    public Result<String> like(@RequestParam Integer dynamicId, @RequestParam(required=false, defaultValue="1") Integer userId) {
        try {
            this.interactionService.like(userId, dynamicId);
            return Result.success("OK", "success");
        }
        catch (Exception e) {
            return Result.error("\u70b9\u8d5e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/publish"})
    public Result<Integer> publish(@RequestBody PublishDynamicDTO dto) {
        try {
            if (dto.getUserId() == null) {
                dto.setUserId(1);
            }
            if (dto.getMediaType() == null) {
                dto.setMediaType(1);
            }
            if (dto.getVisibility() == null) {
                dto.setVisibility(1);
            }
            Integer dynamicId = this.publishService.publish(dto);
            return Result.success(dynamicId);
        }
        catch (Exception e) {
            return Result.error("\u53d1\u5e03\u52a8\u6001\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/publish/upload"}, consumes={"multipart/form-data"})
    public Result<String> uploadDynamicMedia(@RequestParam(value="file") MultipartFile file) {
        try {
            String url = this.mediaUploadService.uploadDynamicMedia(file);
            return Result.success(url);
        }
        catch (Exception e) {
            return Result.error("\u5a92\u4f53\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/publish/upload/batch"}, consumes={"multipart/form-data"})
    public Result<List<String>> uploadDynamicMediaBatch(@RequestParam(value="files") MultipartFile[] files) {
        try {
            List<String> urls = this.mediaUploadService.uploadDynamicMediaBatch(files);
            return Result.success(urls);
        }
        catch (Exception e) {
            return Result.error("\u6279\u91cf\u5a92\u4f53\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Result<String> handleMaxUploadSizeExceeded(MaxUploadSizeExceededException e) {
        return Result.error("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236\uff0c\u5355\u4e2a\u6587\u4ef6\u6700\u592710MB\uff0c\u8bf7\u538b\u7f29\u540e\u91cd\u8bd5");
    }

    @PostMapping(value={"/comment"})
    public Result<String> addComment(@RequestBody CommentCreateDTO dto) {
        try {
            String[] imageUrls = null;
            if (dto.getImageList() != null && !dto.getImageList().isEmpty()) {
                imageUrls = dto.getImageList().toArray(new String[0]);
            } else if (dto.getImages() != null && !dto.getImages().trim().isEmpty()) {
                imageUrls = dto.getImages().split(",");
            }
            Integer uid = dto.getUserId() != null ? dto.getUserId() : 1;
            Integer parentId = dto.getParentCommentId() != null ? dto.getParentCommentId() : 0;
            this.commentService.addComment(uid, dto.getDynamicId(), dto.getContent(), imageUrls, parentId);
            return Result.success("OK", "success");
        }
        catch (Exception e) {
            return Result.error("\u53d1\u8868\u8bc4\u8bba\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @GetMapping(value={"/comment/list/{dynamicId}"})
    public Result<PageResult<DynamicComments>> listComments(@PathVariable Integer dynamicId, @RequestParam(defaultValue="1") Integer pageNum, @RequestParam(defaultValue="10") Integer pageSize) {
        try {
            return Result.success(this.commentService.listComments(dynamicId, pageNum, pageSize));
        }
        catch (Exception e) {
            return Result.error("\u67e5\u8be2\u8bc4\u8bba\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/comment/like"})
    public Result<String> likeComment(@RequestParam Integer commentId, @RequestParam(required=false, defaultValue="1") Integer userId) {
        try {
            this.commentService.likeComment(userId, commentId);
            return Result.success("OK", "success");
        }
        catch (Exception e) {
            return Result.error("\u8bc4\u8bba\u70b9\u8d5e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @DeleteMapping(value={"/comment/like/{commentId}"})
    public Result<String> unlikeComment(@PathVariable Integer commentId, @RequestParam(required=false, defaultValue="1") Integer userId) {
        try {
            this.commentService.unlikeComment(userId, commentId);
            return Result.success("OK", "success");
        }
        catch (Exception e) {
            return Result.error("\u53d6\u6d88\u8bc4\u8bba\u70b9\u8d5e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @DeleteMapping(value={"/like/{dynamicId}"})
    public Result<String> unlike(@PathVariable Integer dynamicId, @RequestParam(required=false, defaultValue="1") Integer userId) {
        try {
            this.interactionService.unlike(userId, dynamicId);
            return Result.success("OK", "success");
        }
        catch (Exception e) {
            return Result.error("\u53d6\u6d88\u70b9\u8d5e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/favorite"})
    public Result<String> favorite(@RequestParam Integer dynamicId, @RequestParam(required=false, defaultValue="1") Integer userId) {
        try {
            this.interactionService.favorite(userId, dynamicId);
            return Result.success("OK", "success");
        }
        catch (Exception e) {
            return Result.error("\u6536\u85cf\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @DeleteMapping(value={"/favorite/{dynamicId}"})
    public Result<String> unfavorite(@PathVariable Integer dynamicId, @RequestParam(required=false, defaultValue="1") Integer userId) {
        try {
            this.interactionService.unfavorite(userId, dynamicId);
            return Result.success("OK", "success");
        }
        catch (Exception e) {
            return Result.error("\u53d6\u6d88\u6536\u85cf\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @PostMapping(value={"/report"})
    public Result<String> submitReport(@RequestBody @Valid ReportCreateDTO dto) {
        try {
            boolean success = this.reportService.submitReport(dto);
            if (success) {
                return Result.success("\u4e3e\u62a5\u5df2\u63d0\u4ea4\uff0c\u6211\u4eec\u5c06\u5c3d\u5feb\u5904\u7406", "success");
            }
            return Result.error("\u4e3e\u62a5\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        catch (Exception e) {
            return Result.error("\u4e3e\u62a5\u63d0\u4ea4\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

