/*
 * Decompiled with CFR 0.152.
 */
package com.zhentao.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;

@MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.OTHER})
public class JsonTypeHandler
extends BaseTypeHandler<String> {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter);
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String json = rs.getString(columnName);
        return this.convertJsonToString(json);
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String json = rs.getString(columnIndex);
        return this.convertJsonToString(json);
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String json = cs.getString(columnIndex);
        return this.convertJsonToString(json);
    }

    private String convertJsonToString(String json) {
        if (json == null || json.trim().isEmpty()) {
            return null;
        }
        if (json.startsWith("[") && json.endsWith("]")) {
            return json;
        }
        if (json.startsWith("{") && json.endsWith("}")) {
            return json;
        }
        return json;
    }
}

