/*
 * Decompiled with CFR 0.152.
 */
package com.zhentao.service.impl;

import com.zhentao.service.MediaUploadService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MediaUploadServiceImpl
implements MediaUploadService {
    @Value(value="${dynamic.media.upload.path}")
    private String uploadPath;
    @Value(value="${dynamic.media.url.prefix}")
    private String urlPrefix;

    @Override
    public String uploadDynamicMedia(MultipartFile file) {
        System.out.println("========== \u672c\u5730\u5b58\u50a8\u4e0a\u4f20\u5f00\u59cb ==========");
        System.out.println("\u6587\u4ef6\u540d: " + file.getOriginalFilename());
        System.out.println("\u6587\u4ef6\u5927\u5c0f: " + file.getSize() + " bytes");
        System.out.println("\u6587\u4ef6\u7c7b\u578b: " + file.getContentType());
        System.out.println("\u5b58\u50a8\u8def\u5f84: " + this.uploadPath);
        try {
            if (file.isEmpty()) {
                throw new RuntimeException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String originalFilename = file.getOriginalFilename();
            String suffix = this.getSuffix(originalFilename);
            String fileName = "dynamic_" + UUID.randomUUID().toString().replace("-", "") + suffix;
            System.out.println("\u751f\u6210\u6587\u4ef6\u540d: " + fileName);
            File uploadDir = new File(this.uploadPath);
            if (!uploadDir.exists()) {
                boolean created = uploadDir.mkdirs();
                System.out.println("\u521b\u5efa\u4e0a\u4f20\u76ee\u5f55: " + this.uploadPath + ", \u7ed3\u679c: " + created);
            }
            Path filePath = Paths.get(this.uploadPath, fileName);
            Files.write(filePath, file.getBytes(), new OpenOption[0]);
            System.out.println("\u6587\u4ef6\u5df2\u4fdd\u5b58\u5230: " + filePath.toAbsolutePath());
            String mediaUrl = this.urlPrefix + fileName;
            System.out.println("\u751f\u6210\u8bbf\u95eeURL: " + mediaUrl);
            System.out.println("========== \u2713 \u4e0a\u4f20\u5b8c\u6210 ==========");
            return mediaUrl;
        }
        catch (IOException e) {
            System.err.println("========== \u2717 \u4e0a\u4f20\u5931\u8d25 ==========");
            System.err.println("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u5a92\u4f53\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
        catch (Exception e) {
            System.err.println("========== \u2717 \u4e0a\u4f20\u5931\u8d25 ==========");
            System.err.println("\u4e0a\u4f20\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u5a92\u4f53\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Override
    public List<String> uploadDynamicMediaBatch(MultipartFile[] files) {
        System.out.println("========== \u672c\u5730\u5b58\u50a8\u6279\u91cf\u4e0a\u4f20\u5f00\u59cb ==========");
        System.out.println("\u6587\u4ef6\u6570\u91cf: " + (files != null ? files.length : 0));
        ArrayList<String> urls = new ArrayList<String>();
        if (files == null || files.length == 0) {
            return urls;
        }
        try {
            File uploadDir = new File(this.uploadPath);
            if (!uploadDir.exists()) {
                boolean created = uploadDir.mkdirs();
                System.out.println("\u521b\u5efa\u4e0a\u4f20\u76ee\u5f55: " + this.uploadPath + ", \u7ed3\u679c: " + created);
            }
            int index = 0;
            for (MultipartFile file : files) {
                if (file == null || file.isEmpty()) continue;
                System.out.println("\u4e0a\u4f20\u6587\u4ef6 " + ++index + "/" + files.length + ": " + file.getOriginalFilename());
                try {
                    String originalFilename = file.getOriginalFilename();
                    String suffix = this.getSuffix(originalFilename);
                    String fileName = "dynamic_" + UUID.randomUUID().toString().replace("-", "") + suffix;
                    Path filePath = Paths.get(this.uploadPath, fileName);
                    Files.write(filePath, file.getBytes(), new OpenOption[0]);
                    System.out.println("  \u6587\u4ef6\u5df2\u4fdd\u5b58: " + fileName);
                    String mediaUrl = this.urlPrefix + fileName;
                    urls.add(mediaUrl);
                }
                catch (IOException e) {
                    System.err.println("  \u2717 \u6587\u4ef6\u4fdd\u5b58\u5931\u8d25: " + file.getOriginalFilename() + ", \u9519\u8bef: " + e.getMessage());
                    throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
                }
            }
            System.out.println("========== \u2713 \u6279\u91cf\u4e0a\u4f20\u5b8c\u6210\uff0c\u6210\u529f: " + urls.size() + " \u4e2a\u6587\u4ef6 ==========");
        }
        catch (Exception e) {
            System.err.println("========== \u2717 \u6279\u91cf\u4e0a\u4f20\u5931\u8d25 ==========");
            System.err.println("\u9519\u8bef: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("\u6279\u91cf\u5a92\u4f53\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
        return urls;
    }

    private String getSuffix(String name) {
        if (name == null) {
            return "";
        }
        int i = name.lastIndexOf(46);
        return i >= 0 ? name.substring(i) : "";
    }
}

