/*
 * Decompiled with CFR 0.152.
 */
package com.zhentao.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zhentao.common.PageResult;
import com.zhentao.entity.DynamicFavorites;
import com.zhentao.entity.DynamicLikes;
import com.zhentao.mapper.DynamicFavoritesMapper;
import com.zhentao.mapper.DynamicLikesMapper;
import com.zhentao.mapper.UserDynamicsMapper;
import com.zhentao.service.InteractionService;
import com.zhentao.vo.DynamicVO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InteractionServiceImpl
implements InteractionService {
    @Autowired
    private DynamicLikesMapper likesMapper;
    @Autowired
    private DynamicFavoritesMapper favoritesMapper;
    @Autowired
    private UserDynamicsMapper userDynamicsMapper;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private static final String LIKE_COUNT_KEY = "dynamic:like:";
    private static final String FAVORITE_COUNT_KEY = "dynamic:favorite:";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void like(Integer userId, Integer dynamicId) {
        DynamicLikes like = new DynamicLikes();
        like.setUserId(userId);
        like.setDynamicId(dynamicId);
        like.setCreatedAt(LocalDateTime.now());
        try {
            this.likesMapper.insert(like);
            this.incrementCacheSafely(LIKE_COUNT_KEY + dynamicId, 1L);
            this.userDynamicsMapper.update(null, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"dynamic_id", (Object)dynamicId)).setSql("like_count = like_count + 1"));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unlike(Integer userId, Integer dynamicId) {
        this.likesMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).eq((Object)"dynamic_id", (Object)dynamicId));
        this.decrementCacheSafely(LIKE_COUNT_KEY + dynamicId, 1L);
        this.userDynamicsMapper.update(null, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"dynamic_id", (Object)dynamicId)).setSql("like_count = CASE WHEN like_count>0 THEN like_count-1 ELSE 0 END"));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void favorite(Integer userId, Integer dynamicId) {
        DynamicFavorites fav = new DynamicFavorites();
        fav.setUserId(userId);
        fav.setDynamicId(dynamicId);
        fav.setCreatedAt(LocalDateTime.now());
        try {
            this.favoritesMapper.insert(fav);
            this.incrementCacheSafely(FAVORITE_COUNT_KEY + dynamicId, 1L);
            this.userDynamicsMapper.update(null, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"dynamic_id", (Object)dynamicId)).setSql("favorite_count = favorite_count + 1"));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unfavorite(Integer userId, Integer dynamicId) {
        this.favoritesMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).eq((Object)"dynamic_id", (Object)dynamicId));
        this.decrementCacheSafely(FAVORITE_COUNT_KEY + dynamicId, 1L);
        this.userDynamicsMapper.update(null, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"dynamic_id", (Object)dynamicId)).setSql("favorite_count = CASE WHEN favorite_count>0 THEN favorite_count-1 ELSE 0 END"));
    }

    @Override
    public PageResult<DynamicVO> listFavorites(Integer userId, Integer pageNum, Integer pageSize) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        IPage pg = this.userDynamicsMapper.selectPage((IPage)page, (Wrapper)new QueryWrapper());
        List list = pg.getRecords().stream().map(u -> {
            DynamicVO vo = new DynamicVO();
            BeanUtils.copyProperties((Object)u, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
        return new PageResult<DynamicVO>(list, pg.getTotal(), pg.getCurrent(), pg.getSize());
    }

    private void incrementCacheSafely(String key, long delta) {
        try {
            this.redisTemplate.opsForValue().increment((Object)key, delta);
            this.redisTemplate.expire((Object)key, 1L, TimeUnit.DAYS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void decrementCacheSafely(String key, long delta) {
        try {
            Long v = this.redisTemplate.opsForValue().increment((Object)key, -Math.abs(delta));
            if (v != null && v < 0L) {
                this.redisTemplate.opsForValue().set((Object)key, (Object)0);
            }
            this.redisTemplate.expire((Object)key, 1L, TimeUnit.DAYS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

