-- 动态举报表
CREATE TABLE IF NOT EXISTS `dynamic_reports` (
  `report_id` BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '举报ID',
  `dynamic_id` BIGINT(20) NOT NULL COMMENT '被举报的动态ID',
  `reporter_id` BIGINT(20) NOT NULL COMMENT '举报人用户ID',
  `report_type` VARCHAR(50) NOT NULL COMMENT '举报原因类型：spam-垃圾广告，porn-色情低俗，violence-暴力违法，attack-人身攻击，fake-虚假信息，plagiarism-抄袭侵权，other-其他',
  `description` TEXT COMMENT '详细描述',
  `screenshots` TEXT COMMENT '举报截图URL，多张以逗号分隔',
  `contact` VARCHAR(100) COMMENT '联系方式',
  `status` TINYINT(1) NOT NULL DEFAULT 0 COMMENT '处理状态：0-待处理，1-处理中，2-已处理，3-已驳回',
  `handle_result` TEXT COMMENT '处理结果说明',
  `handler_id` BIGINT(20) COMMENT '处理人ID',
  `handle_time` DATETIME COMMENT '处理时间',
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `deleted` TINYINT(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除：0-未删除，1-已删除',
  PRIMARY KEY (`report_id`),
  KEY `idx_dynamic_id` (`dynamic_id`),
  KEY `idx_reporter_id` (`reporter_id`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='动态举报表';

