/*
 * Decompiled with CFR 0.152.
 */
package com.zhentao.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zhentao.common.PageResult;
import com.zhentao.entity.CommentLikes;
import com.zhentao.entity.DynamicComments;
import com.zhentao.mapper.CommentLikesMapper;
import com.zhentao.mapper.DynamicCommentsMapper;
import com.zhentao.service.CommentService;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommentServiceImpl
implements CommentService {
    @Autowired
    private DynamicCommentsMapper commentsMapper;
    @Autowired
    private CommentLikesMapper commentLikesMapper;
    private static final Set<String> SENSITIVE = new HashSet<String>(Arrays.asList("\u50bb", "\u574f\u8bcd", "\u8fdd\u89c4"));

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addComment(Integer userId, Integer dynamicId, String content, String[] imageUrls, Integer parentCommentId) {
        String filtered = this.filterContent(content);
        DynamicComments c = new DynamicComments();
        c.setUserId(userId);
        c.setDynamicId(dynamicId);
        c.setParentCommentId(parentCommentId == null ? 0 : parentCommentId);
        c.setContent(filtered);
        if (imageUrls != null && imageUrls.length > 0) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                c.setImageUrls(mapper.writeValueAsString((Object)imageUrls));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        c.setAuditStatus(1);
        c.setStatus(1);
        c.setCreatedAt(LocalDateTime.now());
        this.commentsMapper.insert(c);
        if (c.getParentCommentId() != null && c.getParentCommentId() > 0) {
            this.commentsMapper.update(null, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"comment_id", (Object)c.getParentCommentId())).setSql("reply_count = reply_count + 1"));
        }
    }

    @Override
    public PageResult<DynamicComments> listComments(Integer dynamicId, Integer pageNum, Integer pageSize) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Page pg = (Page)this.commentsMapper.selectPage((IPage)page, (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dynamic_id", (Object)dynamicId)).eq((Object)"status", (Object)1)).orderByDesc((Object)"created_at"));
        return new PageResult<DynamicComments>(pg.getRecords(), pg.getTotal(), pg.getCurrent(), pg.getSize());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void likeComment(Integer userId, Integer commentId) {
        CommentLikes cl = new CommentLikes();
        cl.setUserId(userId);
        cl.setCommentId(commentId);
        cl.setCreatedAt(LocalDateTime.now());
        try {
            this.commentLikesMapper.insert(cl);
            this.commentsMapper.update(null, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"comment_id", (Object)commentId)).setSql("like_count = like_count + 1"));
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unlikeComment(Integer userId, Integer commentId) {
        this.commentLikesMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId)).eq((Object)"comment_id", (Object)commentId));
        this.commentsMapper.update(null, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"comment_id", (Object)commentId)).setSql("like_count = CASE WHEN like_count>0 THEN like_count-1 ELSE 0 END"));
    }

    private String filterContent(String content) {
        if (content == null) {
            return "";
        }
        String result = content;
        for (String w : SENSITIVE) {
            result = result.replaceAll(w, "*");
        }
        return result;
    }
}

