/*
 * Decompiled with CFR 0.152.
 */
package com.zhentao.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zhentao.common.PageResult;
import com.zhentao.dto.DynamicQueryDTO;
import com.zhentao.entity.UserDynamics;
import com.zhentao.mapper.UserDynamicsMapper;
import com.zhentao.service.UserDynamicsService;
import com.zhentao.vo.DynamicVO;
import com.zhentao.vo.UserSimpleVO;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class UserDynamicsServiceImpl
implements UserDynamicsService {
    @Autowired
    private UserDynamicsMapper userDynamicsMapper;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String DYNAMIC_CACHE_KEY = "dynamic:detail:";
    private static final String VIEW_COUNT_KEY = "dynamic:view:";

    @Override
    public PageResult<DynamicVO> getDynamicList(DynamicQueryDTO queryDTO) {
        Page page = new Page((long)queryDTO.getPageNum().intValue(), (long)queryDTO.getPageSize().intValue());
        IPage<UserDynamics> dynamicsPage = this.userDynamicsMapper.selectDynamicsWithUserInfo((Page<UserDynamics>)page, queryDTO.getCurrentUserId(), queryDTO.getAuditStatus() != null ? queryDTO.getAuditStatus() : 1, queryDTO.getVisibility() != null ? queryDTO.getVisibility() : 1);
        List voList = dynamicsPage.getRecords().stream().map(this::convertToVO).collect(Collectors.toList());
        return new PageResult<DynamicVO>(voList, dynamicsPage.getTotal(), dynamicsPage.getCurrent(), dynamicsPage.getSize());
    }

    @Override
    public DynamicVO getDynamicDetail(Integer dynamicId, Integer userId) {
        String cacheKey = DYNAMIC_CACHE_KEY + dynamicId + ":" + userId;
        try {
            Object cached = this.redisTemplate.opsForValue().get((Object)cacheKey);
            if (cached != null) {
                return (DynamicVO)cached;
            }
        }
        catch (Exception cached) {
            // empty catch block
        }
        UserDynamics dynamic = this.userDynamicsMapper.selectDynamicDetailById(dynamicId, userId);
        if (dynamic == null) {
            return null;
        }
        DynamicVO vo = this.convertToVO(dynamic);
        this.increaseViewCount(dynamicId);
        try {
            this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)vo, 5L, TimeUnit.MINUTES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vo;
    }

    @Override
    public PageResult<DynamicVO> getUserDynamics(DynamicQueryDTO queryDTO) {
        if (queryDTO.getTargetUserId() == null) {
            throw new IllegalArgumentException("\u76ee\u6807\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page((long)queryDTO.getPageNum().intValue(), (long)queryDTO.getPageSize().intValue());
        IPage<UserDynamics> dynamicsPage = this.userDynamicsMapper.selectDynamicsByUserId((Page<UserDynamics>)page, queryDTO.getTargetUserId(), queryDTO.getCurrentUserId());
        List voList = dynamicsPage.getRecords().stream().map(this::convertToVO).collect(Collectors.toList());
        return new PageResult<DynamicVO>(voList, dynamicsPage.getTotal(), dynamicsPage.getCurrent(), dynamicsPage.getSize());
    }

    @Override
    public void increaseViewCount(Integer dynamicId) {
        String key = VIEW_COUNT_KEY + dynamicId;
        try {
            this.redisTemplate.opsForValue().increment((Object)key, 1L);
            this.redisTemplate.expire((Object)key, 1L, TimeUnit.DAYS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DynamicVO convertToVO(UserDynamics dynamic) {
        DynamicVO vo = new DynamicVO();
        BeanUtils.copyProperties((Object)dynamic, (Object)vo);
        if (dynamic.getMediaUrls() != null && !dynamic.getMediaUrls().isEmpty()) {
            try {
                List urls = (List)objectMapper.readValue(dynamic.getMediaUrls(), (TypeReference)new TypeReference<List<String>>(){});
                vo.setMediaUrls(urls);
            }
            catch (Exception e) {
                vo.setMediaUrls(new ArrayList<String>());
            }
        } else {
            vo.setMediaUrls(new ArrayList<String>());
        }
        if (dynamic.getUser() != null) {
            UserSimpleVO userVO = new UserSimpleVO();
            userVO.setUserId(dynamic.getUser().getUserId());
            userVO.setNickname(dynamic.getUser().getNickname());
            userVO.setAvatarUrl(dynamic.getUser().getAvatarUrl());
            userVO.setGender(dynamic.getUser().getGender());
            vo.setUser(userVO);
        }
        return vo;
    }
}

