/*
 * Decompiled with CFR 0.152.
 */
package com.zhentao.service.impl;

import com.zhentao.dto.ReportCreateDTO;
import com.zhentao.entity.DynamicReports;
import com.zhentao.mapper.DynamicReportsMapper;
import com.zhentao.service.ReportService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    private final DynamicReportsMapper reportsMapper;

    @Override
    public boolean submitReport(ReportCreateDTO dto) {
        DynamicReports report = new DynamicReports();
        report.setDynamicId(dto.getDynamicId());
        report.setReporterId(dto.getReporterId());
        report.setReportType(dto.getReportType());
        report.setDescription(dto.getDescription());
        report.setContact(dto.getContact());
        List<String> screenshots = dto.getScreenshots();
        if (screenshots != null && !screenshots.isEmpty()) {
            report.setScreenshots(String.join((CharSequence)",", screenshots));
        }
        report.setStatus(0);
        return this.reportsMapper.insert(report) > 0;
    }

    public ReportServiceImpl(DynamicReportsMapper reportsMapper) {
        this.reportsMapper = reportsMapper;
    }
}

