-- 为 dynamic_comments 表添加 image_urls 字段
-- 用于支持评论带图片功能

-- 检查字段是否已存在
SET @col_exists = 0;
SELECT COUNT(*) INTO @col_exists 
FROM information_schema.COLUMNS 
WHERE TABLE_SCHEMA = DATABASE()
  AND TABLE_NAME = 'dynamic_comments'
  AND COLUMN_NAME = 'image_urls';

-- 如果字段不存在，则添加
SET @sql = IF(@col_exists = 0,
    'ALTER TABLE `dynamic_comments` ADD COLUMN `image_urls` TEXT COMMENT ''评论图片URL（多张以逗号分隔）'' AFTER `content`',
    'SELECT ''字段 image_urls 已存在，无需添加'' AS message');

PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- 显示执行结果
SELECT '✅ dynamic_comments 表结构更新完成！' AS status;

